<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('v1')->group(function(){
      Route::get('/soliciters'                               ,'api\SolicitersController@index');      
     
      Route::get('/processos'                                ,'api\ProcessosController@index');
      Route::put('processos/{process}'                       ,'api\ProcessosController@update');    
     
      Route::get('/status'                                   ,'api\StatusController@index');

      Route::get('/permissoes'                               ,'api\PermissaoController@index'); 
      Route::get('/permissoes/status'                        ,'api\PermissaoController@status'); 
      
  
      Route::get('/usuarios'                                  ,'api\UserController@index');


      Route::get('/historico'                                 ,'api\HistoricoController@index'); 
     


      Route::get('/user/logued'                              ,'api\UserController@getLogued'); 

      Route::put('/docsparecer/atualizar/{docsparecer}'      ,'api\DocsParecerController@update'); 

      Route::put('/docsdecisao/atualizar/{docsdecisao}'      ,'api\DocsDesisaoController@update'); 
   
     
      Route::get('/eventos'                                  ,'api\EventController@index');
      Route::post('/eventos'                                 ,'api\EventController@store');
     

      Route::get('/comunicacao'                              ,'api\ComunicacaoController@index');
     
    

      //Auth::user()
});   