@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Solicitante
          <small>atualizar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Solicitante</a></li>
          <li class="active">atualizar</li>
        </ol>
      </section>
    <section class="content">
     

     <!------------------------------------------------------------------------>

     <div class="row">


        
        @include('partials.validation')      
         



{{--

        <div class="col-md-4">


     
                          

                <!-- Profile Image -->
                   <div class="box box-info">
                  <div class="box-body box-profile">
                   
                    <img class="profile-user-img img-responsive img-circle" src="/images/solicitante/{{$item->id}}.jpg" alt="{{$item->nome}}">
                    <h3 class="profile-username text-center">{{$item->nome}}</h3>
                    <p class="text-muted text-center">{{$item->matricula}}</p>
                    <ul class="list-group list-group-unbordered">
                
                    
                
                      <li class="list-group-item">
                        <b>Pessoa:</b> <a class="pull-right">{{$item->tipo_pessoa}}</a>
                      </li>
                      <li class="list-group-item">
                        <b>Documento:</b> <a class="pull-right">{{$item->documento}}</a>
                      </li>

                      <li class="list-group-item">
                        <b>Telefone:</b> <a class="pull-right">{{$item->telefone}}</a>
                      </li>
                        
                     <li class="list-group-item">
                        <b>Email:</b> <a class="pull-right">{{$item->email}}</a>
                      </li>
                      <li class="list-group-item">
                        <b>Telefone:</b> <a class="pull-right">{{$item->telefone}}</a>
                      </li>
      
                      <li class="list-group-item">
                        <b>Obs:</b>{{$item->obs}}</li>
                    </ul>
                   </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->

              </div>
            
--}}



            <div class="col-md-12">              
           


                    <!-- Horizontal Form -->
                    <div class="box box-info">
                      <div class="box-header with-border">
                        <h3 class="box-title">Altere os dados do solicitante</h3>
                      </div>
                      <!-- /.box-header -->
                      <!-- form start -->
                      <form class="form-horizontal" action="{{route('solicitante.update',$item->id)}}" method="post" enctype="multipart/form-data">
                        <div class="box-body">
                          
                                {{ csrf_field() }}
                           

                          <input type="hidden" name="id" value="{{$item->id}}">


                         
                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Nome</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="nome" name="nome"  value="{{old('nome',$item->nome)}}">
                         </div>
                     </div> 


                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Situação</label>          
                           <div class="col-sm-10">
                    
                           <select name="situacao" id="situacao" class="form-control" value="{{old('pessoa')}}">
                           <option  value="">Selecione</option>
                            
                            <option value="Servidor em Atividade" {{'Servidor em Atividade' == $item->situacao ? 'selected':'' }} >Servidor em Atividade</option>
                            <option value="Servidor Inativo" {{'Servidor Inativo' == $item->situacao ? 'selected':'' }}>Servidor Inativo</option>
                            <option value="Empresa Em Atividade" {{'Empresa Em Atividade' == $item->situacao ? 'selected':'' }}>Empresa Em Atividade</option>
                            <option value="Empresa Inativa" {{'Empresa Inativa' == $item->situacao ? 'selected':'' }}>Empresa Inativa</option>
                            <option value="Pessoa Fisica - Cidadão" {{'Pessoa Fisica - Cidadão' == $item->situacao ? 'selected':'' }}>Pessoa Fisica - Cidadão</option>
                            
                      </select>
                         </div>
                     </div> 


                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Lotação</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="lotacao" name="lotacao"  value="{{old('lotacao',$item->lotacao)}}">
                         </div>
                     </div> 

                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Cargo</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="cargo" name="cargo"  value="{{old('cargo',$item->cargo)}}">
                         </div>
                     </div> 

                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Local De Trabalho</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="local_de_trabalho" name="local_de_trabalho"  value="{{old('lotacao',$item->local_de_trabalho)}}">
                         </div>
                     </div> 





                     

                    
                     <div class="form-group">
                      <label for="matricula" class="col-sm-2 control-label">Matricula</label>          
                         <div class="col-sm-10">
                          <input type="text" class="form-control"  id="matricula" name="matricula" maxlength="15"  value="{{old('matricula',$item->matricula)}}">
                       </div>
                   </div> 

                  

                   <div class="form-group">
                    <label for="pessoa" class="col-sm-2 control-label">Tipo</label>          
                    <div class="col-sm-10">
                       

                      <select name="pessoa" id="pessoa" class="form-control" value="{{old('pessoa',$item->pessoa)}}">
                              @foreach( \App\Soliciter::PESSOA as  $key=>$pessoa)
                                   <option value="{{$key}}"  {{$item->pessoa == $key ? 'selected':'' }}   >{{$pessoa}}</option>
                              @endforeach                     
                      </select>



                    </div>
                 </div> 
                       
                 <div class="form-group">
                  <label for="documento" class="col-sm-2 control-label">CPF/CNPJ</label>          
                  <div class="col-sm-10">
                      <input type="tel" class="form-control" id="documento" name="documento"  maxlength="18" value="{{old('documento',$item->documento)}}">
                  </div>
               </div> 

               <div class="form-group">
                  <label for="rg" class="col-sm-2 control-label">RG/IE</label>          
                  <div class="col-sm-10">
                      <input type="tel" class="form-control" id="rg" name="rg"  value="{{old('rg',$item->rg)}}">
                  </div>
               </div> 

                  
                   <div class="form-group">
                      <label for="telefone" class="col-sm-2 control-label">Telefone</label>          
                      <div class="col-sm-10">
                          <input type="tel" class="form-control" id="telefone" name="telefone"  value="{{old('telefone',$item->telefone)}}">
                      </div>
                   </div> 

                   <div class="form-group">
                       <label for="email" class="col-sm-2 control-label">Email</label>          
                       <div class="col-sm-10">
                          <input type="text" class="form-control" id="email" name="email"  value="{{old('email',$item->email)}}">
                       </div>
                   </div> 

                 

                    <div class="form-group">
                       <label for="foto" class="col-sm-2 control-label">Obs:</label>          
                        <div class="col-sm-10">
                               <textarea  class="form-control" id="foto" name="obs">{{$item->obs}}</textarea>
                        </div>
                   </div> 
{{--
                   <div class="form-group">
                           <label for="foto" class="col-sm-2 control-label"></label>          
                            <div class="col-sm-10">
                                 <gs-image/>
                            </div>
                       </div> 

--}}
                        
  


                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">

                           <a href="{{route('solicitante.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 
                           @if(Auth::user()->getPermissoes[12]->status == 'ativo')    
                           
                               <gs-button  title="Atualizar Solicitante"  mensagem="Deseja Atualizar Os Dados do Solicitante ?" label="ATUALIZAR"  status="1" ></gs-button>


                           @endif
                        </div>
                        <!-- /.box-footer -->
                      </form>
                    </div>
                 


        
      
        <!-- /.col -->
      </div>
      <!-- /.row -->

    
    
    
    
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
