<?php
/**
 * VFM - veno file manager: admin-panel/view/admin-head-apperarance.php
 * main appearance setting process
 *
 * PHP version >= 5.3
 *
 * @category  PHP
 * @package   VenoFileManager
 * @author    Nicola Franchini <support@veno.it>
 * @copyright 2013 Nicola Franchini
 * @license   Exclusively sold on CodeCanyon: https://codecanyon.net/item/veno-file-manager-host-and-share-files/6114247
 * @link      http://filemanager.veno.it/
 */

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    /**
    * Skins
    */
    $_CONFIG['skin'] = isset($_POST['skin']) ? $_POST['skin'] : $_CONFIG['skin'];

    /**
    * Progress bar
    */
    $progressColor = filter_input(INPUT_POST, "progressColor", FILTER_SANITIZE_STRING);
    $_CONFIG['progress_color'] = $progressColor ? $progressColor : "";
    $_CONFIG['show_percentage'] = isset($_POST['show_percentage']) ? true : false;
    $_CONFIG['single_progress'] = isset($_POST['single_progress']) ? true : false;

    /**
    * Description
    */
    // Sanitize string
    $postdescription = strip_tags($_POST['description'], '<p><div><a><span><strong><b><em><i><u><img><iframe><input><textarea><button><br><hr><table><thead><tbody><tfoot><tr><td><th><ul><ol><li></label><code><pre>');

    $_CONFIG['description'] = $postdescription;

    /**
    * Sticky alerts
    */
    $_CONFIG['sticky_alerts'] = isset($_POST['sticky_alerts']) ? true : false;

    $stickyv = isset($_POST['sticky_alerts_pos_v']) ? $_POST['sticky_alerts_pos_v'] : 'top';
    $stickyh = isset($_POST['sticky_alerts_pos_h']) ? $_POST['sticky_alerts_pos_h'] : 'left';

    $_CONFIG['sticky_alerts_pos'] = $stickyv.'-'.$stickyh;

    /**
     * Audio notifications
     */
    $_CONFIG['audio_notification'] = empty($_POST['audio_notification']) ? false : filter_input(INPUT_POST, 'audio_notification', FILTER_SANITIZE_STRING);

    /**
    * App icon
    */
    $removeappico = filter_input(INPUT_POST, "remove_app_ico", FILTER_SANITIZE_STRING);

    $destination = "_content/uploads/favicon.ico";
    $destinationPNG = "_content/uploads/favicon-152.png";

    if (isset($_FILES['app_ico']['name']) && $_FILES['app_ico']['error'] !== 4) {
        $app_ico = $admin->uploadImage($_FILES['app_ico'], 'app-ico', false);
        $source = "_content/uploads/".$app_ico;

        if (file_exists($source)) {

            include_once 'class/class.php-ico.php';

            $ico_lib = new PHP_ICO($source, array(array(16, 16), array(32, 32), array(48, 48), array(64, 64)));
            $ico_lib->save_ico($destination);

            $ico_lib_png = new PHP_ICO($source, array(array(152, 152)));
            $ico_lib_png->save_ico($destinationPNG);
            unlink($source);
        }
    } else {
        if ($removeappico) {
            if (file_exists($destination)) {
                unlink($destination);
            }

            if (file_exists($destinationPNG)) {
                unlink($destinationPNG);
            }
        }
    }

    /**
    * Navbar logo
    */
    $navbar_logo_new = false;

    $removenavlogo = filter_input(INPUT_POST, "remove_navbar_logo", FILTER_SANITIZE_STRING);

    $navbar_logo_new = $removenavlogo ? false : $setUp->getConfig('navbar_logo', false);

    if (isset($_FILES['navbar_logo']['name']) && $_FILES['navbar_logo']['error'] !== 4) {
        $navbar_logo_new = $admin->uploadImage($_FILES['navbar_logo'], 'navbar-logo');
    }

    $_CONFIG['navbar_logo'] = $navbar_logo_new;

    /**
    * Custom Header
    */
    $removelogo = filter_input(INPUT_POST, "remove_logo", FILTER_SANITIZE_STRING);

    $logonew = $removelogo ? false : $setUp->getConfig('logo', false);

    if (isset($_FILES['header_image']['name']) && $_FILES['header_image']['error'] !== 4) {
        $logonew = $admin->uploadImage($_FILES['header_image'], 'header-image');
    }
    $_CONFIG['logo'] = $logonew;

    $logo_margin = filter_input(INPUT_POST, "logo_margin", FILTER_VALIDATE_INT);
    $_CONFIG['logo_margin'] = $logo_margin ? $logo_margin : 0;

    $header_padding = filter_input(INPUT_POST, "header_padding", FILTER_VALIDATE_INT);
    $_CONFIG['header_padding'] = $header_padding ? $header_padding : 0;

    $banner_width = filter_input(INPUT_POST, "banner_width", FILTER_SANITIZE_STRING);
    $_CONFIG['banner_width'] = $banner_width ? $banner_width : $setUp->getConfig('banner_width', 'wide');

    $_CONFIG['align_logo'] = isset($_POST['align_logo']) ? $_POST['align_logo'] : $setUp->getConfig('align_logo', 'center');

    $credits = filter_input(INPUT_POST, "credits", FILTER_SANITIZE_STRING);
    $credits_link = filter_input(INPUT_POST, "credits_link", FILTER_SANITIZE_URL);

    $_CONFIG['credits'] = $credits ? $credits : false;
    $_CONFIG['credits_link'] = $credits_link ? $credits_link : false;
    $_CONFIG['hide_credits'] = isset($_POST['hide_credits']) ? true : false;

    /**
    * Update config
    */
    $con = '$_CONFIG = ';
    if (false === (file_put_contents(
        'config.php', "<?php\n\n $con".var_export($_CONFIG, true).";\n"
    ))
    ) {
        Utils::setError('Error saving config file');
    } else {
        Utils::setSuccess($setUp->getString('settings_updated'));
    }
}
