@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Processos
          <small>arquivos</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Processos</a></li>
          <li class="active">arquivos</li>
        </ol>
      </section>
    <section class="content">
  

     <!------------------------------------------------------------------------>

   

     <div class="row">

            @include('partials.validation')

            <div class="col-lg-12">              
           
               <div class="box box-info">
             
                 <br>
                    
                          <form action="{{route('processos.arquivos')}}" class="form-horizontal" method="get"> 
                              <div class="col-lg-12">
                                <div class="form-group">    
                                  <label for="serch" class="col-lg-1 control-label">Pesquisar</label>          
                                  <div class="col-lg-11">
                                    <input type="text" class="form-control" name="search">
                                  </div>
                                </div>
                              </div>

                              <div class="col-lg-6 off-set-3">
                                  <div class="form-group">    
                                       <label for="serch" class="col-lg-2 control-label">Status</label>          
                                        <div class="col-lg-9">  
                                          <select  class="form-control" name="status_id" id="status_id"  disabled>
                                           
                                                 @foreach (\App\Status::all() as $key => $item)
                                                   @if($item->id == 3)
                                                    <option selected value="{{$item->id}}">{{$item->status}}</option>
                                                  @endif
                                                @endforeach
                                          </select>
                                        </div>
                                  </div>
                                </div>  
               
                                
                              <div class="col-lg-4">
                                  <div class="form-group">    
                                       <label for="serch" class="col-lg-2 control-label">Periodo</label>          
                                        <div class="col-lg-5">  
                                             <input id="date" type="date" name="dtinicial" class="form-control">
                                        </div>
                                        <div class="col-lg-5">  
                                            <input id="date" type="date" name="dtFinal" class="form-control">
                                        </div>
                                  </div>
                                </div>  

                                <div class="col-lg-2">
                                    <button type="submit" class="btn btn-block btn-primary">PESQUISAR</button>
                                </div>  
  


                          </form>
                      
                  <br>

            
               
                 <div class="box-body">
               
                    {{--\App\Process::find(1)->tipo_parecer--}}


                      <table  class="table table-bordered table-hover">
                        <thead>
                        <tr>

                          <th width = "3%" class="text-center">Processo</th>
                          <th width = "3%">Criação</th>
                          <th width = "2%">Alteração</th>
                          <th width = "8%">Status</th>
                          <th width = "8%">Codigo</th>
                       
                          <th width = "3%">Local</th> 
                          <th width = "3%">Prioridade</th>      
                          <th width = "3%">Tipo</th>
                          <th>Solicitante:</th>
                          <th width = "5">Visualizar</th>
                          @if(Auth::user()->getPermissoes[21]->status == 'ativo')

                          <th width="5">Desarquivar</th> 
                    
                          @endif
                      
                          
                        
                       
                         
                         
                        </tr>
                        </thead>
                        <tbody>
                         
                          @foreach ($itens as $key => $item)

                        
                        
                           <tr style="background-color:{{\App\Status::find($item->status_id)->cor}}">
                              <td class="text-center">{{$item->protocolo}}</td>
                              <td>{{date('d/m/Y',strtotime($item->criacao))}}</td>                           
                              <td>{{date('d/m/Y',strtotime($item->alteracao))}}</td>
                              <td>{{(\App\Status::find($item->status_id))->status}}</td>
                          
                              <td>{{(\App\Historico::where('processes_id',$item->id)->get()->last())->recebimento}}</td>
                        
                              <td>{{(\App\Setor::find($item->setor_id))->setor}}</td>
                              <td>{{ $item->prioridade}}</td>

                              <td>{{\App\TipoProcesso::find($item->tipo_processo_id)->tipo}}</td>
                            
                              <td>{{$item->nome}}</td>
                            
                              <td><a href="{{route('processos.pdf',$item->id)}}"  target="_blank" class="btn btn-xs  btn-primary btn-block">VISUALIZAR</a></td>
                       
                              @if(Auth::user()->getPermissoes[21]->status == 'ativo')
                              
                                  <td align="center">
                                 
                                      <a href="{{route('processos.desarquivar',$item->id)}}" ><i class="fa fa-square-o" aria-hidden="true"></i></a>
                                   
                                 </td>
                               @endif  
                              
                            </tr>
                        
                          @endforeach
                    
                      
                        </tbody>
                       
                      </table>

  

               
                  
             

                 </div>
               </div>

               <nav aria-label="..." class="text-center">
                  {!! $itens->render() !!}
    
              </nav>

            </div>
      </div>

                  
      <nav aria-label="..." class="text-center">
         {!! $itens->render() !!}
      </nav>
  
      <div class="row">
        <div class="col-md-12">
            <a href="{{route('index')}}" class="btn btn-primary pull-right" style="margin:5px;width:110px"><b>SAIR</b></a>
        </div> 
      </div> 
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

{{------------------------------}}
{{-------------------------------}}




  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
