<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('processes_id')->unsigned();
            $table->foreign('processes_id')->references('id')->on('processes')->onDelete('cascade'); 

            $table->integer('usuario_id')->unsigned(); 
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');

            $table->text('mensagem')->nullable();


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('events');
    }
}
