<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMensagensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mensagens', function (Blueprint $table) {
            $table->increments('id');
        
        
            $table->integer('setor_id')->unsigned(); 
            $table->foreign('setor_id')->references('id')->on('setors')->onDelete('cascade');
          
            $table->integer('usuario_id')->unsigned(); 
            $table->foreign('usuario_id')->references('id')->on('users')->onDelete('cascade');
        
            $table->integer('tipos_comunicacao_id')->unsigned(); 
            $table->foreign('tipos_comunicacao_id')->references('id')->on('tipos_comunicacao')->onDelete('cascade');    
            $table->string('numero',15)->nullable();
            $table->text('titulo')->nullable();
            $table->text('mensagem')->nullable();
          



            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mensagens');
    }
}
