<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProcessTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('processes', function (Blueprint $table) {

            $table->increments('id')->unsigned();                         

            $table->integer('usuario_id')->unsigned();
            $table->foreign('usuario_id')->references('id')->on('users'); 

            $table->integer('setor_id')->unsigned();
            $table->foreign('setor_id')->references('id')->on('setors'); 
           
            $table->integer('solicitante_id')->unsigned(); 
            $table->foreign('solicitante_id')->references('id')->on('soliciters');

            $table->integer('tipo_processo_id')->unsigned(); 
            $table->foreign('tipo_processo_id')->references('id')->on('tipo_processos'); 


            $table->integer('status_id')->unsigned(); 
            $table->foreign('status_id')->references('id')->on('status');    
         
            $table->integer('prioridade_id')->unsigned(); 
            $table->foreign('prioridade_id')->references('id')->on('prioridades');    


             
            $table->string('tipo_parecer',25)->nullable();
            $table->string('especie',25)->nullable();
            $table->text('parecer')->nullable();
            $table->string('protocolo',25);                       
            $table->date('criacao'); // ?????????????
            $table->date('alteracao'); // data alteracao           
            $table->date('prazo')->nullable();
            $table->text('obs')->nullable() ; // observaões*/
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('processes');
    }
}
