<?php

namespace App;

//use Illuminate\Notifications\Notifiable;
//use Illuminate\Foundation\Auth\User as Authenticatable;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;


class User extends Authenticatable implements JWTsubject
{
    use Notifiable;


    protected $guard = 'api'; 

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
       'funcao_id','matricula','nivel','status','cargo','name','email','telefone','id_profissional','password','obs',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];
  
 
    public function getJWTIdentifier(){
        return $this->id;
    }
 
    public function getJWTCustomClaims(){
      return [
         'name' => $this->name,
         'email' => $this->email 
       ];
    }



    public function Setors(){
        return $this->belongsToMany(Setor::class);     
    }

    const STATUS = [
        1 => 'ATIVO',
        2 => 'INATIVO'
    ];

    const NIVEL = [
        1 => 'ADMINISTRADOR',
        2 => 'USUÁRIO'
    ];


    const CARGO = [
        1 => 'ATIVO',
        2 => 'PASSIVO'
    ];


    public static function getMatricula(){
          
        $characters01 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $characters02 = '0123456789';
      
        $randstring01='';
        $randstring02='';

        for ($i=0; $i<2; $i++) {
            $randstring01 .= $characters01[rand(0, strlen($characters01)-1)];
        }
        
        for ($i=0; $i < 5; $i++) {
            $randstring02 .= $characters02[rand(0, strlen($characters02)-1)];
        }

        return $randstring01 . '-'  . $randstring02;
    }


    public function getPermissoes()
    {
        return $this->hasMany('App\Permissao','users_id','id');
    }

}