<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class TelefoneNumber implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if(!empty($value)){
        
           $non_digits = [' ','(',')','-','.','+'];
           $nums = str_replace($non_digits,'',$value);
          
           if((strlen($nums) == 10) || (strlen($nums) == 11))
             {
                return true;
             } 

            return false;
        }

       return true;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The validation error message.';
    }
}
