<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;


class Process extends Model
{
    
    protected $table    = 'processes';

    protected $fillable =   [   'id',
                                'usuario_id',
                                'setor_id',
                                'solicitante_id',
                                'tipo_processo_id',
                                'status_id',
                                'prioridade_id',                                
                                'tipo_parecer',
                                'justificativa',
                                'amparo_legal',
                                'especie',
                                'parecer',
                                'protocolo',
                                'criacao',
                                'alteracao',     
                                'prazo',                     
                                'obs',
                                'created_at'
                        ];




    public function getCriacaoAttribute($value){
        return (new Carbon($value))->format('d/m/Y');     
    }                      

    public function setCriacaoAttribute($value){
        $this->attributes['criacao'] =   implode('-',   array_reverse(explode('/',$value)))  ;       
    } 

    public function getAlteracaoAttribute($value){
        return (new Carbon($value))->format('d/m/Y');     
    }                      
 
    public function setAlteracaoAttribute($value){
         $this->attributes['alteracao'] =   implode('-',   array_reverse(explode('/',$value)))  ;       
    } 


    public function getPrazoAttribute($value){
        return (new Carbon($value))->format('d/m/Y');     
    }                      
 
    public function setPrazoAttribute($value){
         $this->attributes['prazo'] =   implode('-',   array_reverse(explode('/',$value)))  ;       
    } 


    public function Users(){
        return $this->belongsToMany(User::class);     
    }


    public function Status(){
        return $this->belongsTo(Status::class);     
    } 
 

    public static function AtualDate(){
       
         return   ((new Carbon))->format('d/m/Y');
    }



    public static function getRecebido(){
          
            $characters01 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $characters02 = '0123456789';
          
            $randstring01='';
            $randstring02='';

            for ($i=0; $i<3; $i++) {
                $randstring01 .= $characters01[rand(0, strlen($characters01)-1)];
            }
            
            for ($i=0; $i < 4; $i++) {
                $randstring02 .= $characters02[rand(0, strlen($characters02)-1)];
            }

            return $randstring01 . ''  . $randstring02;
    }


   public static function getNumeroProcesso(){   
       
           $carbon = (new Carbon())->format('Y');
		   $id = (  ((DB::table('processes')->whereYear('criacao','>=', (int)(new Carbon())->format('Y') )->count()) + 1) ); 
           $id = str_pad($id,6,'0',STR_PAD_LEFT);
           return $carbon . $id;
   
   // CORREO PELO CDGIO ACIMA PARA GERAR O NUMERO DO PROCESSO NO ANO SEGUINTE
    //public static function getNumeroProcesso(){   
       
        //   $carbon = (new Carbon())->format('Y'); 
         //  $id = (  ((DB::table('processes')->where('criacao','>=', (int)(new Carbon())->format('Y') )->count()) + 1) ); 
        //   $id = str_pad($id,6,'0',STR_PAD_LEFT);
       //    return $carbon . $id;
    }



    public function getHistorico(){
        return $this->hasMany('App\Historico','processes_id','id');
    }


    public function getPareceres(){
        return $this->hasMany('App\Parecer','processes_id','id');
    }

    public function getDocs(){
        return $this->hasMany('App\Documento','processes_id','id');
    }


    public function getSetor(){
        return $this->belongsTo('App\Setor','setor_id','id');
    }

    public function getOrigem(){
          return $this->hasOne('App\Origem','processes_id','id');
    }
    
    
    public function getDestino(){
           return $this->hasOne('App\Destino','processes_id','id');
    }
     

    public static function getPermission($setor_id){

       
     
        if(\Auth::user()->nivel == 1){
            return true;
        }

  
        if(\Auth::user()->nivel == 2){ 
    
       
        foreach (\Auth::user()->Setors as $key => $setor) {
          
            if($setor->id == $setor_id){
                 return true ;
           }
       }

    } 
        return false;

    }
 

}
