<?php

namespace App\Listeners;

use App\Events\AddFotoUserEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\FotoUserController;

class AddFotoUserEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */

    protected $foto;

    public function __construct(FotoUserController $foto)
    {
        $this->foto = $foto;
    }

    /**
     * Handle the event.
     *
     * @param  AddFotoUserEvent  $event
     * @return void
     */
    public function handle(AddFotoUserEvent $event)
    {
         return  $this->foto->store($event->getFoto());
    }
}
