<?php

namespace App\Listeners;

use App\Events\AddDocsEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\DocumentoController;

class AddDocsEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */

    protected $data;
     
    public function __construct(DocumentoController $data)
    {
        $this->data = $data;
    }

    /**
     * Handle the event.
     *
     * @param  AddDocsEvent  $event
     * @return void
     */
    public function handle(AddDocsEvent $event)
    {
        $this->data->store($event->getData());
    }
}
