<?php

namespace App\Listeners;

use App\Events\AddDestinoEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\DestinoController;

class AddDestinoEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    protected $data; 

    public function __construct(DestinoController $data)
    {
        $this->data = $data;
    }

    /**
     * Handle the event.
     *
     * @param  AddDestinoEvent  $event
     * @return void
     */
    public function handle(AddDestinoEvent $event)
    {
        $this->data->store($event->getData());
    }
}
