<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;


class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        
  
     
        return [
                    'name'       => 'required|'.Rule::unique('users')->ignore($request->all()['id']).'|min:6|max:100',
                    'matricula'  => 'required|'.Rule::unique('users')->ignore($request->all()['id']).'|min:5|max:15',
                    'email'      => 'required|'.Rule::unique('users')->ignore($request->all()['id']).'|max:50',       
                    'funcao_id'  => 'required',
                    'cargo'      => 'required',
                    'telefone'   => 'between:13,14',
                    'obs'        => 'max:350|',            
                ];
    }

    public function messages()
    {
        return [
           
           'funcao_id.required' => 'Selecione a Função !' ,

           'cargo.required' => 'Selecione o tipo de função !' ,

           'name.required'  => 'Digite o nome do suário !',
           'name.unique'    => 'Ja temos um usuário com este nome cadastrado !',
           'name.min'       => 'O digite o nome completo do usuário !',
           'name.max'       => 'O nome do usuário não pode ter mais de 100 caracteres !',


           'matricula.required'  => 'Digite o número da matrícula !',
           'matricula.unique'    => 'Ja temos um usuário com esta matricula registrada !',
           'matricula.min'       => 'D digite no mínimo 5 caracteres no campo matrículoa !',
           'matricula.max'       => 'Digite no máximo 15 caracteres no campo matrículoa !',


           'matricula.required'  => 'Digite a matricula  do usuário !',
           'matricula.unique'    => 'Já temos um usuário com esta matricula cadastrada !',
           'matricula.max'       => 'A matricula não pode ter mais de 10 caracteres !',

           'email.required'  => 'Digite o email do usuario !',
         //  'email.email'     => 'Digite um email valido !',
           'email.unique'    => 'Este email já esta sendo utilizado !',
           'email.max'       => 'Este email deve ter no maximo 50 caracteres !',


           'telefone.between'   => 'Número de telefone invalido !',
           
           'obs.max'         => 'Digite no maximo 350 caractes para o campo obsrvação !',
         
        ];
    }
}
