<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class StatusRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
           
       
     
        return [ 'status'       => 'required|min:3|max:15', ];
    }

    public function messages()
    {
        return [
           'status.required'    => 'O campo status não pode estar vazio !',
           'status.min'         => 'Digite no minimo 3 caracteres !',
           'status.max'         => 'Digite no maximo 15 caracteres!',        
        ];
    }
}