<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class SoliciterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
           
        $id =   $this->route('id');
     
        return [
                    'nome'       => 'required|min:6|max:100',
                    'rg'         => 'max:15',
                    'telefone'   => 'between:13,14',
                    'documento'  => 'required|min:11|max:18|unique:soliciters,documento,' . $id ,                   
                //    'documento'  => ['present:',new ValidaDocumento],                   
                 //   'email'      => 'email|max:50',        
                ];
    }

    public function messages()
    {
        return [
           'nome.required'      => 'Digite o nome do solicitante !',
           'nome.min'           => 'O digite o nome completo do usuário !',
           'nome.max'           => 'O nome do usuário não pode ter mais de 100 caracteres !',

           'rg.max'             => 'O RG do usuário não pode ter mais de 15 caracteres !',

           'documento.max'      => 'Preecha o documento  com no maximo  18 caracteres!', 
           'documento.min'      => 'Preecha o documento  com no minimo  11 caracteres!', 
          
           'documento.required' => 'Preecha o documento corretamente !', 
           'documento.unique'   => 'Este solicitante já se encontra cadastrado !',      

           'telefone.between'   => 'Número de telefone invalido !',

          // 'email.email'      => 'Digite um email valido !',
          // 'email.max'        => 'Este email deve ter no maximo 50 caracteres !',
           
           'obs.max'            => 'Digite no maximo 100 caractes para o campo obsrvação !',
         
        ];
    }
}
