<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class DecisaoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
     
        $rules =  [
            
             'processes_id'        => 'required|integer',
             'user_id'             => 'required|integer',
             'setor_id'            => 'required|integer', 
             'decisao'             => 'required',
             'justificativa'       => 'required',
             'documentos'       => 'between:0,3',
    
            ];

            if(isset($request->all()['documentos'])){     
                foreach ($request->all()['documentos'] as $key => $document) {
                  $rules['documentos.'.$key]  = 'mimes:pdf';
                 }
            }
           
          
            return $rules;

    }

    public function messages()
    {
        $rules =   [
           'processes_id.required'          => 'O processo Não Foi Selecionado !',
           'processes_id.integer'          => 'O processo Não Foi Selecionado !',
           'user_id.required'               => 'O Usúario não esta logado !',
           'user_id.integer'               => 'O Usúario não esta logado !',
           'setor_id.required'              => 'Defina o setor !',
           'setor_id.integer'              => 'Defina o setor !',
           'decisao.required'               => 'Defina o tipo de decisão !',
           'justificativa.required'         => 'Digite a Justificativa !',
           'documentos.0.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.1.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.2.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.3.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.4.mimes'       => 'Tipo de arquivo incopativel !',
        ];

        return $rules;
    }
}


