<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;


class ComunicacaoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
      
        $rules = [
           'usuario_id'            => 'required|numeric',
           'setor_id'              => 'required|numeric',   
           'tipos_comunicacao_id'  => 'required|numeric',
           'receptores'            => 'required|array',
           'titulo'                => 'required',
           'mensagem'              => 'required',
         ];

      
        
        if(isset($request->all()['documentos'])){     
          foreach ($request->all()['documentos'] as $key => $document) {
            $rules['documentos.'.$key]  = 'mimes:pdf';
           }
        }
     
    
        return $rules;

    }

    public function messages()
    {
        $rules =  [
           'usuario_id.required'    => 'Usuário não esta logado !',
           'usuario_id.numeric'     => 'Usuário não esta logado !',
          
          
           'setor_id.required'       => 'Selecione o setor de onde sera enviada a CI !',
           'setor_id.numeric'        => 'Selecione o setor de onde sera enviada a CI !',
           
           'tipos_comunicacao_id.required'  => 'Selecione o tipo !',
           'tipos_comunicacao_id.numeric'   => 'Selecione o tipo !',


           'receptores.required'      => 'Selecione os usuários que receberam a CI !',
           'receptores.array'         => 'Selecione os usuários que receberam a CI !',

            'titulo.required'         => 'Digite o titulo !',

            'mensagem.required'         => 'Digite a  mensagem !',
           
           
           'documentos.size'          => 'Faça o Uplaod de No maximo 3 arquivos',
           'documentos.0.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.1.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.2.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.3.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.4.mimes'       => 'Tipo de arquivo incopativel !',
        ];


       
          return $rules;
    }
}
