<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Events\SetDocsComunicationEvent;
use App\Comunicacao;


class ComunicacaoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         
        $id = $request->all()['id'] ?? 0;
   
     

        $enviadas      =  (Comunicacao::join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('mensagens.usuario_id','LIKE',$id))
                          ->get();


        $recebidas     =  (Comunicacao::join('receptores','receptores.mensagem_id','LIKE','mensagens.id')
                          ->join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('receptores.status','LIKE','ABERTO')
                          ->where('receptores.user_id','LIKE',$id))                          
                          ->get();
      
        $visuaizados     = (Comunicacao::join('receptores','receptores.mensagem_id','LIKE','mensagens.id')
                          ->join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('receptores.status','LIKE','FECHADO')
                          ->where('receptores.user_id','LIKE',$id   ))
                          ->get();


    

        return ['enviadas'=>$enviadas,'recebidas'=>$recebidas,'visualizadas'=>$visuaizados];
  
    }


}
