<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use App\User;





class UpdatePasswordController extends Controller
{

    
    public function process(\App\Http\Requests\PasswordRequest $request)
    {
        $resposta =  $this->getPasswordResetTableRow($request)->count() > 0 ? $this->changePassword($request) : $this->tokenNotFoundResponse();
       
        if($resposta['id']  == 1){
             return redirect()->route('reset.send')->with('warning',$resposta['message']);
        }
       
        if($resposta['id']  == 2){
           return redirect()->route('login')->with('success',$resposta['message']);
        }
    }
    
    private function getPasswordResetTableRow($request){
        return DB::table('password_resets')->where(['token' =>$request->token]);
    }
    
    private function tokenNotFoundResponse()
    {
        return ['id'=>1,'message'=>'Link para Recuperar Senha Invalido<br>Tente Novamente!'];
    }
    
    private function changePassword($request)
    {   $email = DB::table('password_resets')->select('email')->where('token','LIKE' , $request->token)->first()->email;
        $user = User::whereEmail($email)->first();
        $user->update(['password'=>  bcrypt($request->password)]);
        $this->getPasswordResetTableRow($request)->delete();
        return ['id'=>2,'message'=>'Senha Alterada<br>Faça Login Com A Nova Senha!'];
    }
    
}
