<?php

namespace App\Http\Controllers\Api\Auth;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use App\Mail\ResetEmail;




class ResetPasswordController extends Controller
{
   
    public function sendEmail(Request $request){
        
      
      

       if ($this->hasMail($request->all()['email']) == 0) {
           return redirect()->back()->with('danger', 'Email não existe !');
       }

       if ($this->hasMail($request->all()['email']) >  1) {

            return redirect()->back()->with('warning', 'Existe um problema eu seu cadastro, por favor entre em contato com administrdor');

       }

       $token =  $this->createToken($request->all()['email']);

    
      
       (Mail::to($request->all()['email'])->send(new ResetEmail($token)));
    

       return redirect()->back()->with('success', 'Link enviado para o email !');

     
    }


    private function createToken($email)
    {

        $oldToken = DB::table('password_resets')->where('email', $email)->first();
     
        if ($oldToken) {
           return $oldToken->token;
        }
        $token = str_random(60);
        $this->saveToken($token, $email);
        return $token;
    }

    
    private function saveToken($token, $email)
    {
        DB::table('password_resets')->insert([
            'email' => $email,
            'token' => $token,
            'created_at' => Carbon::now()
        ]);
    }



    private function hasMail($email){
        return  DB::table('users')->
        where('email',$email)->
        count();        
    }


}
