<?php

namespace App\Http\Controllers;
use \App\Http\Requests\SoliciterRequest as Request;
use App\Events\AddFotoUserEvent as FotoEvent;
use Illuminate\Support\Facades\DB;
use \App\Soliciter;

class SoliciterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */ 
    public function index(\Illuminate\Http\Request $request)
    {


       // dd($request->all());


        $search =  $request->get('search') ?? '';
        //$search =  explode(':',$search);
        
     //   $nome       =  '%' ; 
       
      

       // foreach ($search as $key => $item) {
         //   $nome      =  $nome      == '%' ? (strtolower($item) == 'nome'      ? $search[$key+1] :'%') : $nome ;
        //} 


      
         
        $itens = DB::table('soliciters')
         ->select('soliciters.id','soliciters.nome')
             
        ->where('nome', 'like' ,'%'. $search .'%')
        ->orderBy('nome', 'asc')
        ->paginate(25);



        return view('soliciter.lista')->with(compact('itens'));



     
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('soliciter.cadastra');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(\App\Http\Requests\SoliciterRequest  $request)
    {

      


        $item =  Soliciter::create($request->all());

        if(isset($request->all()['foto'])){
            $data = ['id'   => $item->id,
                     'foto' => $request->all()['foto'],
                     'pasta' => 'solicitante'];
            \Event::fire(new FotoEvent($data));
        }
       
      //  return redirect()->back()->with('success', 'Dados cadastrados com sucesso !');

      return redirect()->route('processos.create')->with('success', 'Dados cadastrados com sucesso !');  
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = Soliciter::findOrFail($id);     
     
           return view('soliciter.atualiza')->with(compact('item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

 
    //  dd($request->all());


        $item = Soliciter::findOrfail($id);
   
   
   
   
        $item->update($request->all());

         


        if(isset($request->all()['foto'])){
            $data = ['id'   => $id,
                    'foto' => $request->all()['foto'],
                    'pasta' => 'solicitante'];
          
                    \Event::fire(new FotoEvent($data));
        }
         
     
      // return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
      return redirect()->route('solicitante.index')->with('success', 'Dados cadastrados com sucesso !'); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


    public function destroy($id)
    {
        //
    }
}
