<?php

namespace App\Http\Controllers;
set_time_limit(10000);

use \App\Http\Requests\ProcessoRequest as Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;



use App\Events\AddOrigemEvent  as AddOrigemEvent;
use App\Events\AddDestinoEvent as AddDestinoEvent;
use App\Events\UpdateOrigemEvent  as UpdateOrigemEvent;
use App\Events\UpdateDestinoEvent as UpdateDestinoEvent;

use App\Events\AddDocsEvent as AddDocsEvent;
use App\Events\AddHistoricoEvent as AddHistoricoEvent;

use Fpdf;

use \App\Process;



class ProcessosController  extends Controller
{


    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('process.lista');
    }


    public function arquivos(\Illuminate\Http\Request $request)
    {
        $search   =  $request->get('search') ?? '';
        $search   =  explode(':',$search);
        $status   =  $request->get('status_id') ?? '%';
        $dtInicial =  $request->get('dtinicial') ?? '1900-01-01';
        $dtFitnal  =  $request->get('dtFinal')   ?? '2060-01-01';
        $nome       =  '%' ; 
        $protocolo  =  '%' ;  

        foreach ($search as $key => $item) {
            $nome      =  $nome      == '%' ? (strtolower($item) == 'nome'      ? $search[$key+1] :'%') : $nome ;
            $protocolo =  $protocolo == '%' ? (strtolower($item) == 'protocolo' ? $search[$key+1] :'%') : $protocolo;
        }
  
        $itens = DB::table('processes')
               ->join('soliciters', 'soliciters.id', '=', 'processes.solicitante_id')              
               ->select('processes.id','processes.setor_id','processes.status_id','processes.protocolo','processes.criacao','processes.prioridade_id','processes.tipo_processo_id','processes.tipo_parecer','parecer','processes.alteracao','soliciters.nome')
               ->where('nome', 'like' ,'%'. $nome .'%')
               ->where('protocolo', 'like' ,'%'. $protocolo .'%') 
               ->where('processes.status_id', 'like' , 3  )
               ->whereDate('criacao', '>= ' ,  $dtInicial )
               ->whereDate('criacao', '<= ' ,  $dtFitnal )             
               ->orderBy('processes.id', 'desc')
               ->paginate(25);

               return view('process.arquivos')->with(compact('itens'));

   
    }


    
    public function reservados(\Illuminate\Http\Request $request)
    {
        $search     =  $request->get('search') ?? '';
        $search     =  explode(':',$search);
        $status     =  $request->get('status_id') ?? '%';
        $dtInicial  =  $request->get('dtinicial') ?? '1900-01-01';
        $dtFitnal   =  $request->get('dtFinal')   ?? '2060-01-01';
        $nome       =  '%' ; 
        $protocolo  =  '%' ;  

        foreach ($search as $key => $item) {
            $nome      =  $nome      == '%' ? (strtolower($item) == 'nome'      ? $search[$key+1] :'%') : $nome ;
            $protocolo =  $protocolo == '%' ? (strtolower($item) == 'protocolo' ? $search[$key+1] :'%') : $protocolo;
         }
  
        $itens = DB::table('processes')
               ->join('soliciters', 'soliciters.id', '=', 'processes.solicitante_id')              
               ->select('processes.id','processes.setor_id','processes.status_id','processes.protocolo','processes.criacao','processes.prioridade','processes.tipo_processo_id','processes.tipo_parecer','parecer','processes.alteracao','soliciters.nome')
               ->where('nome', 'like' ,'%'. $nome .'%')
               ->where('protocolo', 'like' ,'%'. $protocolo .'%') 
               ->where('processes.status_id', 'like' , 4  )
               ->whereDate('criacao', '>= ' ,  $dtInicial )
               ->whereDate('criacao', '<= ' ,  $dtFitnal )             
               ->orderBy('processes.id', 'desc')
               ->paginate(25);

               return view('process.reservados')->with(compact('itens'));

   
    }



 


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
        return view('process.registra');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        

        $request['protocolo'] =  Process::getNumeroProcesso();
            
        
        if (isset($request->all()['reservado'])){
            ( $request['status_id']  = 4);
        }
        
        
        $process                  =  Process::create($request->all());
        $request['id']            =  $process->id;
        $request['local']         =  $process->getSetor->setor ;
        $request['setor_id']      =  $process->getSetor->id ;
        $request['status']        =  $process->status->status;
        $request['tipo_parecer']  =  (isset($request->all()['tipo_parecer']) ? $request->all()['tipo_parecer'] : '');
        $request['parecer']       =  (isset($request->all()['parecer'])      ? $request->all()['parecer']      : '');
        
        
        
        
        $request['situacao']      =  'EM ANDAMENTO';   
        
        if (isset($request->all()['reservado'])){
            
            $request['situacao']      =  'RESERVADO';   
            
        }
        
        
        if(isset($request->all()['documentos'])){
            
            $this->setDocumentos($request);
            
        }
        /////registra o historico interno////
        $request = new Request();
        $request['processes_id']       =  $process->id;
        $request['titulo']             =  'PROCESSO INICIADO';
        $request['evento']             =  (' Status ' .  \App\Status::findOrFail($process->status_id)->status .
        ', Setor  ' .  \App\Setor::findOrFail($process->setor_id)->setor) ;  
        
        
        
        $this->addHistoricoInterno($request);
        ////////////////////////////////////////// 
        
      

      
       
          $item = Process::findOrFail($process->id);
          $protocolo = $item->protocolo;
    
          
          
          
      



       // broadcast(new \App\Events\ProcessNotificationEvent(['origem'=>$process->getSetor->setor . ' enviou um novo processo',  'local'=> $process->getSetor->id]));

        
        return view('process.atualiza')->with(compact('item','protocolo'));

    }


     /**
     * Display the specified resource.     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
     {
            $item = Process::findOrFail($id);
            return view('process.atualiza')->with(compact('item'));  
     }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
   
        
     ///dd($request->all());


      $criacao = explode('/', $request->all()['criacao']);
      $criacao['1'] =    ((int)$criacao['1'] ) > 9 ? ((int)$criacao['1']  ) :  '0' . ((int)$criacao['1']  ) ; 
    
      
      $request['criacao']  = (implode('/', ( $criacao)));
      
      
      
    
      $alteracao = explode('/', $request->all()['alteracao']);
      $alteracao['1'] =    ((int)$alteracao['1'] ) > 9 ? ((int)$alteracao['1']  ) :  '0' . ((int)$alteracao['1']  ) ; 
      $request['alteracao']  = (implode('/', ($alteracao)));  
       

      $prazo = explode('/', $request->all()['prazo']);
      $prazo['1'] =    ((int)$prazo['1']  ) > 9 ? ((int)$prazo['1']  ) :  '0' . ((int)$prazo['1']   ) ; 
      $request['prazo']  = (implode('/',($prazo)));
      
  

      $item = Process::find($id);

    

      $request['alteracao'] =    ($item->alteracao  ==   $request['alteracao']) ? (date ( 'd/m/Y')) : $request['alteracao'];
        
     
      
        
          $request['setor_id']      =   ((is_null($request->all()['setor_id'])) ? $item->getSetor->id :   $request->all()['setor_id']);//
          $request['status_id']     =    $request->all()['setor_id'] ==  $item->setor_id ?  $request->all()['status_id'] : 2;//
        
        
           $item->update($request->all());
          
          if(isset($request->all()['documentos'])){
             $this->setDocumentos($request);
          }
       
           /////registra o historico interno////
           $request = new Request();
           $request['processes_id']       =  $item->id;
           $request['titulo']             =  'PROCESSO ATUALIZADO';
           $request['evento']             =  (' Status ' .  \App\Status::findOrFail($item->status_id)->status .
                                                         ', Setor  ' .  \App\Setor::findOrFail($item->setor_id)->setor);
                                                       
           $this->addHistoricoInterno($request);
           ////////////////////////////////////////// 


         //   broadcast(new \App\Events\ProcessNotificationEvent(['origem'=>$item->getSetor->setor . ' recebeu um novo processo','local'=> $item->getSetor->id]));



           return view('process.lista')->with('success', 'Dados atualizados com sucesso !');

         //  return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       
    }

    public function setRecebido($id){

           $process = Process::findOrFail($id);
           $process->status_id = 1;
           $process->save();  


           /////registra o historico interno////
           $request = new Request();
           $request['processes_id']       =  $process->id;
           $request['titulo']             =  'PROCESSO ATUALIZADO ';
           $request['evento']             =  (' Status ' . \App\Status::findOrFail($process->status_id)->status .
                                                         ', Setor '.  \App\Setor::findOrFail($process->setor_id)->setor) . 
                                                         ',  Nº: '  . \App\Process::getRecebido();  


           $this->addHistoricoInterno($request);
           ////////////////////////////////////////// 

           return redirect()->back();  
        

    }


    public function showprocess(\Illuminate\Http\Request $request)
    {
        $item =  (Process::find($request->all()['id']));
        return view('process.parecer')->with(compact('item'));
    }

  

    public function getProcessPDF($id){

       
      $x=0;
      $y=0;  

      $process =    Process::find($id);
  
      \Fpdf::AddPage();
       
      \Fpdf::SetTitle('Prefeitura Municipal De Retirolandia - Ba',true);
    
      \Fpdf::SetMargins(0,0,0);      
     
      \Fpdf::Rect(15,5,185,29);
 
      \Fpdf::SetFillColor(200,200,200); 

      \Fpdf::Rect($x+145,5,55,29); 
      
      $y+=35; 
      
      \Fpdf::Rect($x+15,$y-1,185,5,'F');


      \Fpdf::Rect($x+15,$y+10,185,5,'F');
      
      \Fpdf::Rect($x+15,$y-1,130,11);
      \Fpdf::Rect($x+145,$y-1,55,11);
      
      \Fpdf::Rect($x+110,$y+10,90,12);
      \Fpdf::Rect($x+15,$y+10,95,12);
      
      
      \Fpdf::Rect($x+15,$y+22,185,5,'F');
      
      
      
      \Fpdf::Rect($x+15,$y+22,130,12);      
      \Fpdf::Rect($x+110,$y+22,35,12);      
      \Fpdf::Rect($x+145,$y+22,55,12);
      
      \Fpdf::Rect($x+15,$y+34,185,5,'F');
      
      //  \Fpdf::Rect($x+15,$y+34,35,12);
      
      
      \Fpdf::Rect($x+110,$y+34,90,12);
      \Fpdf::Rect($x+15,$y+34,95,12);
      
      
      
      \Fpdf::Rect($x+15,$y+46,185,5,'F');
      \Fpdf::Rect($x+15,$y+46,185,12); 
      
 
      \Fpdf::Rect($x+15,$y+58,185,5,'F');
      \Fpdf::Rect($x+15,$y+58,185,12); 
      
      //\Fpdf::Rect($x+15,$y+70,185,5,'F');
     // \Fpdf::Rect($x+15,$y+70,185,12); 
      

      \Fpdf::Rect($x+15,$y+70,185,5,'F');
      \Fpdf::Rect($x+15,$y+70,185,60);


      \Fpdf::Rect($x+15,$y+130,185,5,'F');
      \Fpdf::Rect($x+15,$y+130,185,35);


     for($i=16;$i<=200; $i+=2 ){
          \Fpdf::Line($i ,  $y+168, $i-1,  $y+168);
      }
     
      \Fpdf::SetFont('Arial', 'B', 10);
      \Fpdf::SetXY(15,$y+170);
      \Fpdf::Cell(190,5,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C');


     //for($i=16;$i<=200; $i+=2 ){
       // \Fpdf::Line($i ,  $y+198, $i-1,  $y+198);
     //}
    

     \Fpdf::Line(15 ,  215.2, 200,  215.2);

     \Fpdf::Line(15 ,  225.2, 200,  225.2);

     \Fpdf::Line(15 ,  235, 200,  235);

     \Fpdf::Line(15 ,  245.2, 200,  245.2);

     \Fpdf::Line(15 ,  253, 200,  253);

      //\Fpdf::Rect($x+15,$y+235,185,5,'F');
     // \Fpdf::Rect($x+15,$y+235,93,12);
     // \Fpdf::Rect($x+108,$y+235,92,12);

  
 
      \Fpdf::SetFont('Arial', 'B', 13);
      \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,10,23,23);
      \Fpdf::SetXY(0,0);
      \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C');
    
      \Fpdf::SetFont('Arial', 'B', 15);

      \Fpdf::SetXY(160,15);
      \Fpdf::Cell(30,5,'Processo',0,1,'C');

      \Fpdf::SetXY(155,22);
      \Fpdf::Cell(40,5,utf8_decode($process->protocolo ),0,2,'C');
     
      \Fpdf::SetFont('Arial', 'B', 8.3);


     
      \Fpdf::SetXY(15,$y-1);
      \Fpdf::Cell(90,5,utf8_decode('Requerente /  Solicitante'),0,1,'L');


      \Fpdf::SetXY(145,$y-1);
      \Fpdf::Cell(90,5,utf8_decode('Matricula'),0,1,'L');

       
      \Fpdf::SetXY(15,$y+10.3);
      \Fpdf::Cell(35,5,utf8_decode('Setor / Secretaria:'),0,1,'L');

      
      \Fpdf::SetXY(110,$y+10.3);
      \Fpdf::Cell(55,5,utf8_decode('Lotado Em:'),0,1,'L');
    
      \Fpdf::SetXY(15,$y+22.3);
      \Fpdf::Cell(90,5,utf8_decode('E-mail'),0,1,'L');

      \Fpdf::SetXY(110,$y+22.3);
      \Fpdf::Cell(90,5,utf8_decode('Telefone'),0,1,'L');


      \Fpdf::SetXY(145,$y+22.3);
      \Fpdf::Cell(90,5,utf8_decode('Cargo'),0,1,'L');
      
      \Fpdf::SetXY(15,$y+34);
      \Fpdf::Cell(45,5,utf8_decode('CPF / CNPJ'),0,1,'L');

   
      \Fpdf::SetXY(110,$y+34);
      \Fpdf::Cell(45,5,utf8_decode('RG / IE'),0,1,'L');


      \Fpdf::SetXY(15,$y+46.2);
      \Fpdf::Cell(45,5,utf8_decode('O Que Requer / Tipo de Processo'),0,1,'L');


      \Fpdf::SetXY(15,$y+58.2);
      \Fpdf::Cell(45,5,utf8_decode('Amparo Legal'),0,1,'L');

      
     \Fpdf::SetXY(15,$y+70.2);
      \Fpdf::Cell(45,5,utf8_decode('Conteudo do Processo'),0,1,'L');


      \Fpdf::SetXY(15,$y+130.2);
      \Fpdf::Cell(45,5,utf8_decode('Justificativa'),0,1,'L');
      
      //\Fpdf::SetXY(15,250.3);
      //\Fpdf::Cell(45,5,utf8_decode('Assinatura do Solicitante'),0,1,'L');
      
      
      //\Fpdf::SetXY(108,250.3);
     // \Fpdf::Cell(45,5,utf8_decode('Data de Recebimento'),0,1,'L');


     \Fpdf::SetXY(15,$y+4);
     \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->nome ),0,2,'L');
     
     \Fpdf::SetXY(145  ,$y+4);
     \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->matricula  ),0,2,'L');

      
      \Fpdf::SetXY(15  ,49.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Setor::find($process->setor_id)->setor),0,2,'L');

      \Fpdf::SetXY(110  ,49.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->lotacao ),0,2,'L');


      \Fpdf::SetXY(15  ,62.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->email ),0,2,'L');

      \Fpdf::SetXY(110  ,62.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->telefone ),0,2,'L');


      \Fpdf::SetXY(145  ,62.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->cargo),0,2,'L');
      
    
    
      \Fpdf::SetXY(15  ,73.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->documento ),0,2,'L');

      
      \Fpdf::SetXY(110  ,73.5);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->rg ),0,2,'L');

      
      //\Fpdf::SetXY(15 ,228);
      //\Fpdf::Cell(95,6,utf8_decode('RECORTE LINHA ABAIXO'),0,2,'L');

      \Fpdf::SetXY(15 ,210);
      \Fpdf::Cell(95,6,utf8_decode('Processo:'),0,2,'L');
      
      \Fpdf::SetXY(40 ,210);
      \Fpdf::Cell(95,6,utf8_decode('Data:'),0,2,'L');
      
      \Fpdf::SetXY(70 ,210);
      \Fpdf::Cell(95,6,utf8_decode('Requerente:'),0,2,'L');


      \Fpdf::SetXY(15 ,220);
      \Fpdf::Cell(95,6,utf8_decode('O Que Requer / Pedido:'),0,2,'L');

      \Fpdf::SetXY(15 ,230);
      \Fpdf::Cell(95,6,utf8_decode('Situacao do Solicitante:'),0,2,'L');

      \Fpdf::SetXY(70 ,230);
      \Fpdf::Cell(95,6,utf8_decode('Lotado Solicitante:'),0,2,'L');

      \Fpdf::SetXY(15 ,240);
      \Fpdf::Cell(95,6,utf8_decode('Cargo do Solicitante:'),0,2,'L');


      \Fpdf::SetXY(70 ,240);
      \Fpdf::Cell(95,6,utf8_decode('Local de Trabalho do Solicitante:'),0,2,'L');

      \Fpdf::SetXY(15 ,248);
      \Fpdf::Cell(95,6,utf8_decode('Atendimento:'),0,2,'L');

      \Fpdf::SetXY(15 ,252);
      \Fpdf::Cell(95,6,utf8_decode('Processo Criado Por ' . \App\User::findOrFail( $process->usuario_id)->name .
       ' / Local Atual do Processo: '. \App\Setor::findOrFail($process->setor_id)->setor  ),0,2,'L');

      //\Fpdf::SetXY(15 ,255);
      //\Fpdf::Cell(95,6,utf8_decode('Local De Trabalho'),0,2,'L');


      
      //\Fpdf::SetXY(135,55.3);
      //\Fpdf::Cell(65,6,utf8_decode($process->criacao),0,2,'C');
      
  
      \Fpdf::SetXY(15,75.3);
      \Fpdf::Cell(185,12,utf8_decode($process->tipo_parecer ),0,2,'L');
   
      \Fpdf::SetXY(15,85.5);
     \Fpdf::Cell(185,6,utf8_decode( \App\TipoProcesso::find($process->tipo_processo_id)->tipo ),0,2,'L');
     
      \Fpdf::SetXY(15 ,98.5);
      \Fpdf::Cell(95,6,utf8_decode($process->amparo_legal),0,2,'L');

      
      \Fpdf::SetFont('Arial', 'B', 8);
      \Fpdf::SetXY(16,111);
      \Fpdf::MultiCell(182,3.2,substr(utf8_decode($process->obs),0,1900),0,'J');
      
 
      \Fpdf::SetFont('Arial', 'B', 8);
      \Fpdf::SetXY(16,171);
      \Fpdf::MultiCell(182,3.2,substr(utf8_decode($process->justificativa),0,900),0,'J');

     
      \Fpdf::SetXY(15 ,215);
      \Fpdf::Cell(95,6,utf8_decode($process->protocolo),0,2,'L');

      \Fpdf::SetXY(40 ,215);
      \Fpdf::Cell(95,6,utf8_decode($process->criacao),0,2,'L');

      \Fpdf::SetXY(70 ,215);
      \Fpdf::Cell(95,6,utf8_decode(\App\Soliciter::find($process->solicitante_id)->nome ),0,2,'L');

      \Fpdf::SetXY(15 ,225);
      \Fpdf::Cell(185,6,utf8_decode( \App\TipoProcesso::find($process->tipo_processo_id)->tipo ),0,2,'L');
     


      \Fpdf::SetXY(15 ,234);
      \Fpdf::Cell(185,6,utf8_decode( \App\Soliciter::find($process->solicitante_id)->situacao  ),0,2,'L');     
      \Fpdf::SetXY(70 ,234);
      \Fpdf::Cell(185,6,utf8_decode( \App\Soliciter::find($process->solicitante_id)->lotacao  ),0,2,'L');     
      \Fpdf::SetXY(15 ,244);
      \Fpdf::Cell(185,6,utf8_decode( \App\Soliciter::find($process->solicitante_id)->cargo ),0,2,'L');
     
      \Fpdf::SetXY(70 ,244);
      \Fpdf::Cell(185,6,utf8_decode( \App\Soliciter::find($process->solicitante_id)->local_de_trabalho),0,2,'L');





      //\Fpdf::SetXY(15,265);
      //\Fpdf::Cell(185,8,utf8_decode(     \App\User::findOrFail( $process->usuario_id)->name   ),0,2,'C',0);

      //\Fpdf::SetXY(15,268);
      //\Fpdf::Cell(185,8,utf8_decode(    \App\Setor::findOrFail($process->setor_id)->setor   ),0,2,'C',0);
      
    


     \Fpdf::SetXY(15,260);
     \Fpdf::Cell(185,5,utf8_decode('......................................................................................'),0,1,'C',0);
     \Fpdf::SetXY(15,264);
     \Fpdf::Cell(185,5,utf8_decode('                           Assinatura, Data e Carimbo                                 '),0,1,'C',0);
     \Fpdf::Cell(200,5,utf8_decode('pmr.iprotocolo.app.br/acompanhar'),0,1,'R');

     
      
      //\Fpdf::SetFont('Arial', 'B', 20);
      //\Fpdf::SetXY(109,262.3);
      //\Fpdf::Cell(91,5,utf8_decode('....../......./........'),0,1,'C');
      /*
      */
       $eventos = \App\Event::where('processes_id','LIKE',$id)->get() ;  
      
       if (count($eventos) > 0){

           
           $y=15;
           \Fpdf::AddPage();
           \Fpdf::Rect(15,$y,185,20); 
           \Fpdf::Rect(160,$y,40,20); 
           
           \Fpdf::Rect(15,$y+20,185,5,'F');
           \Fpdf::Rect(15,$y+20,185,12);
           \Fpdf::Rect(160,$y+20,40,12);   
           \Fpdf::Rect(15,$y+32,185,5,'F');   
           \Fpdf::Rect(15,$y+32,185,12);      
           \Fpdf::Rect(15,$y+44,185,5,'F');   
           \Fpdf::Rect(15,$y+44,185,5);   
          
           
           
        
          \Fpdf::SetFont('Arial', 'B', 12);
          \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,17,15,15);
          \Fpdf::SetXY(0,$y-10);
          \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C');
          \Fpdf::SetXY(160,$y+5);
          \Fpdf::Cell(30,5,'Processo',0,1,'C');
          \Fpdf::SetXY(155,$y+10);
          \Fpdf::Cell(40,5,utf8_decode($process->protocolo ),0,2,'C');
          
          
          
          \Fpdf::SetFont('Arial', 'B', 8);

          \Fpdf::SetXY(15 ,$y+20);
          \Fpdf::Cell(95,5,utf8_decode('Requerente'),0,2,'L');

        
          \Fpdf::SetXY(15 ,$y+25);
          \Fpdf::Cell(95,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->nome ),0,2,'L',0);

          \Fpdf::SetXY(160,$y+20);
          \Fpdf::Cell(40,5,utf8_decode('CPF / CNPJ'),0,2,'L',0);
      
          
          \Fpdf::SetXY(160,$y+25);
          \Fpdf::Cell(40,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->documento ),0,2,'L',0);


          \Fpdf::SetXY(15,$y+32);
          \Fpdf::Cell(185,5,utf8_decode('O que requer / Tipo de Processo'),0,2,'L',0);
      
          
          \Fpdf::SetXY(15,$y+37);
          \Fpdf::Cell(185,5,utf8_decode(\App\TipoProcesso::find($process->tipo_processo_id)->tipo ),0,2,'L',0);

          \Fpdf::SetXY(15,$y+44);
          \Fpdf::Cell(185,5,utf8_decode('Eventos de Movimentação de Processo ' . ' ' . $process->protocolo ),0,2,'L',0);
      
          
            $y += 60;

        
            $limit = 5;
            $flag = 0;
        
            foreach ($eventos as $key => $evento) {
                if(($flag == 6 && $limit == 5) || ($flag == 7 && $limit == 6) ){
                    $y=30;
                    $limit = 6;
                    $flag  = 0;
                    \Fpdf::AddPage();
                }  
               $flag++; 
               \Fpdf::Rect(15,$y-11,185,35);   
               \Fpdf::SetXY(15 ,$y-10);
               \Fpdf::MultiCell(185,3.4,substr(utf8_decode($evento->mensagem),0,1000),0,'J',0);
               \Fpdf::SetXY(15 ,$y+18);
               \Fpdf::Cell(185,6,utf8_decode( \App\User::findOrFail($evento->usuario_id)->name) .' - '.  date_format($evento->created_at,'d/m/Y H:i  ')    ,0,2,'R',0);
               $y+=35;
            }
       }


       $pareceres = \App\Parecer::where('processes_id','LIKE',$id)->get() ; 

       if(count($pareceres) > 0){

            foreach ($pareceres as $key => $parecer) {
                $y=15;
                \Fpdf::AddPage();
                \Fpdf::Rect(15,$y,185,20); 
                \Fpdf::Rect(160,$y,40,20); 
                
                \Fpdf::Rect(15,$y+20,185,5,'F');
                \Fpdf::Rect(15,$y+20,185,12);
                \Fpdf::Rect(160,$y+20,40,12);   
                \Fpdf::Rect(15,$y+32,185,5,'F');   
                \Fpdf::Rect(15,$y+32,185,12);      
                \Fpdf::Rect(15,$y+44,185,15,'F');   
                \Fpdf::Rect(15,$y+44,185,15);   
                \Fpdf::Rect(15,$y+59,185,202);   
               
                
                
             
               \Fpdf::SetFont('Arial', 'B', 12);
               \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,17,15,15);
               \Fpdf::SetXY(0,$y-10);
               \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C');
               \Fpdf::SetXY(160,$y+5);
               \Fpdf::Cell(30,5,'Processo',0,1,'C');
               \Fpdf::SetXY(155,$y+10);
               \Fpdf::Cell(40,5,utf8_decode($process->protocolo ),0,2,'C');
               
               
               
               \Fpdf::SetFont('Arial', 'B', 8);
     
               \Fpdf::SetXY(15 ,$y+20);
               \Fpdf::Cell(95,5,utf8_decode('Requerente'),0,2,'L');
     
             
               \Fpdf::SetXY(15 ,$y+25);
               \Fpdf::Cell(95,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->nome ),0,2,'L',0);
     
               \Fpdf::SetXY(160,$y+20);
               \Fpdf::Cell(40,5,utf8_decode('CPF / CNPJ'),0,2,'L',0);
           
               
               \Fpdf::SetXY(160,$y+25);
               \Fpdf::Cell(40,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->documento ),0,2,'L',0);
     
     
               \Fpdf::SetXY(15,$y+32);
               \Fpdf::Cell(185,5,utf8_decode('O que requer / Tipo de Processo'),0,2,'L',0);
           
               
               \Fpdf::SetXY(15,$y+37);
               \Fpdf::Cell(185,5,utf8_decode(\App\TipoProcesso::find($process->tipo_processo_id)->tipo ),0,2,'L',0);
     
               \Fpdf::SetFont('Arial', 'B', 9);
               \Fpdf::SetXY(15,$y+45);
               \Fpdf::MultiCell(184,3,utf8_decode('Parecer do Setor ' . \App\Setor::findOrFail($parecer->setor_id)->setor   .   ', Servidor '. \App\User::findOrFail($parecer->user_id)->name  .' Para o Processo ' .  $process->protocolo ),0,'L');
               \Fpdf::SetFont('Arial', 'B', 11);
               \Fpdf::SetXY(15,$y+61);
               \Fpdf::MultiCell(185,3,utf8_decode($parecer->titulo),0,'C');
               
               \Fpdf::SetFont('Arial', 'B', 8);
               \Fpdf::SetXY(15,$y+66);
               \Fpdf::MultiCell(185,3,utf8_decode(substr($parecer->parecer,0,8000)),0,'J');
               \Fpdf::SetXY(15,$y+255);
               \Fpdf::Cell(185,5 ,  date('d/m/Y',strtotime($parecer->data)  ),0,2,'R',0);

              // date_format($evento->created_at,'d/m/Y H:i  ')

           
               // dd($parecer);
            }


       } 

      

       $decisaofinal = \App\DecisaoFinal::where('processes_id','LIKE',$id)->get() ; 

       if(count($decisaofinal) > 0){
          
            foreach ($decisaofinal as $key => $value) {
               
                $y=15;
                \Fpdf::AddPage();
                \Fpdf::Rect(15,$y,185,20); 
                \Fpdf::Rect(160,$y,40,20); 
                
                \Fpdf::Rect(15,$y+20,185,5,'F');
                \Fpdf::Rect(15,$y+20,185,12);
                \Fpdf::Rect(160,$y+20,40,12);   
                \Fpdf::Rect(15,$y+32,185,5,'F');   
                \Fpdf::Rect(15,$y+32,185,12);      
                \Fpdf::Rect(15,$y+44,185,5);   
                
                \Fpdf::Rect(15,$y+49,185,5,'F');   

                \Fpdf::Rect(15,$y+49,185,71);   
                \Fpdf::Rect(15,$y+120,185,5,'F');   

                \Fpdf::Rect(15,$y+120,185,140);   
               
                
                
             
               \Fpdf::SetFont('Arial', 'B', 12);
               \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,17,15,15);
               \Fpdf::SetXY(0,$y-10);
               \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C');
               \Fpdf::SetXY(160,$y+5);
               \Fpdf::Cell(30,5,'Processo',0,1,'C');
               \Fpdf::SetXY(155,$y+10);
               \Fpdf::Cell(40,5,utf8_decode($process->protocolo ),0,2,'C');
               
               
               
               \Fpdf::SetFont('Arial', 'B', 8);
     
               \Fpdf::SetXY(15 ,$y+20);
               \Fpdf::Cell(95,5,utf8_decode('Requerente'),0,2,'L');
     
             
               \Fpdf::SetXY(15 ,$y+25);
               \Fpdf::Cell(95,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->nome ),0,2,'L',0);
     
               \Fpdf::SetXY(160,$y+20);
               \Fpdf::Cell(40,5,utf8_decode('CPF / CNPJ'),0,2,'L',0);
           
               
               \Fpdf::SetXY(160,$y+25);
               \Fpdf::Cell(40,5,utf8_decode(\App\Soliciter::find($process->solicitante_id)->documento ),0,2,'L',0);
     
     
               \Fpdf::SetXY(15,$y+32);
               \Fpdf::Cell(185,5,utf8_decode('O que requer / Tipo de Processo'),0,2,'L',0);
           
               
               \Fpdf::SetXY(15,$y+37);
               \Fpdf::Cell(185,5,utf8_decode(\App\TipoProcesso::find($process->tipo_processo_id)->tipo ),0,2,'L',0);

               \Fpdf::SetFont('Arial', 'B', 10);
               \Fpdf::SetXY(15,$y+44);
               \Fpdf::Cell(185,5,utf8_decode('Decisão Final'),0,2,'C',0);
           
               \Fpdf::SetFont('Arial', 'B', 8);
               \Fpdf::SetXY(15,$y+49);
               \Fpdf::Cell(185,5,utf8_decode('Decisão'),0,2,'L',0);
           


               \Fpdf::SetXY(15,$y+120);
               \Fpdf::Cell(185,5,utf8_decode('Justificativa'),0,2,'L',0);
               \Fpdf::SetXY(15,$y+55);

               \Fpdf::MultiCell(185,3,utf8_decode(substr($value->decisao,0,8500)),0,'J');
               \Fpdf::SetXY(15,$y+126);
               \Fpdf::MultiCell(185,3,utf8_decode(substr($value->justificativa,0,8000)),0,'J');
               \Fpdf::SetXY(15,$y+255);
               \Fpdf::Cell(185,5,date('d/m/Y',strtotime($value->data)  ),0,2,'R',0);

         //      date_format($evento->created_at,'d/m/Y H:i  ')

            }

       }

      \Fpdf::Output();//984315833 -- daiton
      
      
      exit;

    }


    public  function getHistoricoPDF($id){
                
        $x=0;
        $y=0; 
        $w=3;  
        $l=0;

        $process =    Process::find($id);
    
        \Fpdf::AddPage();


         $this->cabecalho($process->protocolo);        


        $historico =   (\App\Historico::where('processes_id','LIKE',$process->id)->get());
        $p = 55;   

       
        \Fpdf::SetFont('Arial', 'B', 14);
        \Fpdf::SetXY($x+15,$y+38);
        
        \Fpdf::Cell(185,14,utf8_decode('HISTÓRICO'),1,0,'C');
            
         
       
        
        foreach ($historico as $key => $evento) {
             $l++;
            \Fpdf::SetFont('Arial', 'B', 10);
            \Fpdf::SetXY($x+15,$y+$p);
            \Fpdf::Cell(185,6,utf8_decode(  ($evento->created_at)->format('d / m / Y')   . ' - ' . $evento->titulo),1,0,'C');
            \Fpdf::SetFont('Arial', 'B', 8);
            \Fpdf::SetXY($x+15,$y+$p+6);
            \Fpdf::Cell(185,10,utf8_decode( $evento->evento),1,0,'L');
            $p+=18;

            if($l==12){
                $p=10;
                $l=0;
                \Fpdf::AddPage();
            }
        }


        \Fpdf::Output();//984315833 -- daiton
      
      
        exit;    

    }


  
    public  function getEventoPDF($id){
                
        $x=0;
        $y=0; 
        $w=3;  
        $l=0;

        $process =    Process::find($id);
    
        \Fpdf::AddPage();


         $this->cabecalho($process->protocolo);        


        $historico =   (\App\Event::where('processes_id','LIKE',$process->id)->get());
        $p = 55;   

       
        \Fpdf::SetFont('Arial', 'B', 14);
        \Fpdf::SetXY($x+15,$y+35);
        
        \Fpdf::Cell(185,14,utf8_decode('EVENTOS'),1,0,'C');
            
         
       
        
        foreach ($historico as $key => $evento) {
             $l++;
            \Fpdf::SetFont('Arial', 'B', 10);
            \Fpdf::SetXY($x+15,$y+$p);
            \Fpdf::Cell(185,6,utf8_decode(   ($evento->created_at)->format('d / m / Y')   . ' - '  . \App\User::findOrFail($evento->usuario_id)->name   ),1,0,'C');

            \Fpdf::SetFont('Arial', 'B', 8);
            \Fpdf::Rect(15,$y+$p,185,50);   
            \Fpdf::SetXY($x+15,$y+$p+7);
            \Fpdf::MultiCell(185,3,utf8_decode(substr($evento->mensagem,0,8000)),0,'J');
          
          
            $p+=52;

            if($l==4){
                $p=35;
                $l=0;
                \Fpdf::AddPage();
                $this->cabecalho($process->protocolo);  
            }
        }

       
       
       \Fpdf::Output();//984315833 -- daiton
      
      
        exit;    

    }




    private function setDocumentos(Request $request){
        \Event::fire(new AddDocsEvent($request));
    }
    
    
    private function addHistoricoInterno(Request $request){
       (\Event::fire(new AddHistoricoEvent($request)));
    }



    public function desarquivar($id){
        $process = Process::find($id);
        $process->status_id = 1;
        $process->save(); 
        return back();
    }


    private function cabecalho($process){
        \Fpdf::SetTitle('Prefeitura Municipal De Retirolandia - Ba',true);
        \Fpdf::SetMargins(0,0,0);      
        \Fpdf::Rect(15,5,185,29);
        \Fpdf::Rect(145,5,55,29); 
        \Fpdf::SetFont('Arial', 'B', 13);
        \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,10,23,23);
        \Fpdf::SetXY(40,12);
        \Fpdf::Cell(105,15,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C',0);
        \Fpdf::SetXY(145,13);
        \Fpdf::Cell(55,10,utf8_decode('Processo'),0,1,'C',0);
        \Fpdf::SetXY(145,17);
        \Fpdf::Cell(55,10,utf8_decode($process),0,1,'C',0);
    }



    public function processosShow(){
          return view('process.relatorios');
    }
        

    public function processosRelatorios(\Illuminate\Http\Request $request){

        $inicio = (Carbon::createFromFormat('d/m/Y', $request['inicio'] ?? '%' ));
        $fim =  (Carbon::createFromFormat('d/m/Y', $request['fim'] ?? '%'  ))  ;


             
        
		$pages = (Process::where('setor_id','LIKE',$request->all()['setor'])
        ->where('tipo_processo_id','LIKE',$request->all()['tipo_processos_id'])
        ->where('status_id','LIKE',$request->all()['status_id'])
        ->where('created_at', '>=', $inicio)
        ->where('created_at', '<=', $fim)
        ->orderBy($request->all()['order'], 'ASC') 
        ->get()
        ->toArray());



        $pages = array_chunk($pages,15,false);


            foreach ($pages as $k => $itens) {
                        

                        \Fpdf::AddPage();
                        
                        
                        \Fpdf::SetTitle('Prefeitura Municipal De Retirolandia - Ba',true);
                        \Fpdf::SetMargins(0,0,0);      
                        \Fpdf::Rect(15,5,185,29);
                        \Fpdf::Rect(145,5,55,29); 
                        \Fpdf::SetFont('Arial', 'B', 13);
                        \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,10,23,23);
                        \Fpdf::SetXY(40,12);
                        \Fpdf::Cell(105,15,utf8_decode('Prefeitura Municipal De Retirolandia - Ba'),0,1,'C',0);
                        \Fpdf::SetXY(145,13);
                        \Fpdf::Cell(55,10,utf8_decode('Processos'),0,1,'C',0);
                        \Fpdf::SetXY(145,20);
                        \Fpdf::Cell(55,10,utf8_decode( 'Pág:' . ($k+1) ),0,1,'C',0);
                    

                        $y  = 40;
                        $x  = 15 ;
                        $sy = 3.6;
                        $h  = 3.40;

                        \Fpdf::SetXY($x, $y-$sy);
                        \Fpdf::SetFont('Arial', 'B', 8);


                        \Fpdf::Cell(25,$h,'Processo',1,1,'C',0);
                        
                        \Fpdf::SetXY($x+25,$y-$sy);
                        \Fpdf::Cell(135,$h,utf8_decode('Solicitante'),1,1,'C',0);
                        
                        
                        \Fpdf::SetXY($x+160,$y-$sy);
                        \Fpdf::Cell(25,$h,utf8_decode('Data'),1,1,'C',0);
                        
                        \Fpdf::SetFont('Arial', 'B', 7.3); 





                    

                    foreach ( $itens as $key => $process) {
                            
                            \Fpdf::SetXY($x,$y);
                            \Fpdf::Cell(5,((4*$h)+ 0.5),($key+1),1,1,'C',0);
                        
                            \Fpdf::SetXY($x+5,$y);
                            \Fpdf::Cell(20,$h,$process['protocolo'],1,1,'C',0);

                            \Fpdf::SetXY($x+25,$y);            
                            \Fpdf::Cell(160,$h,utf8_decode(\App\Soliciter::find($process['solicitante_id'])->nome),1,1,'L',0);
                            
                            \Fpdf::SetXY($x+160,$y);
                            \Fpdf::Cell(25,$h,  Carbon::createFromFormat('Y-m-d H:i:s', $process['created_at'])->format('d/m/Y H:i'),1,1,'C',0);
                            
                            \Fpdf::SetXY($x+5,$y+$sy);
                            \Fpdf::Cell(20,$h,utf8_decode('Status Inicial:'),1,1,'L',0);
                        
                            \Fpdf::SetXY($x+25,$y+$sy);
                            \Fpdf::Cell(160,$h,utf8_decode(  \App\Historico::where('processes_id','LIKE',$process['id'])->first()->evento     ),1,1,'L',0);

                            \Fpdf::SetXY($x+5,$y+2*$sy);
                            \Fpdf::Cell(20,$h,utf8_decode('Status Atual:'),1,1,'L',0);
                        
                            \Fpdf::SetXY($x+25,$y+2*$sy);
                            \Fpdf::Cell(160,$h,utf8_decode(   \App\Historico::where('processes_id','LIKE',$process['id'])->orderBy('created_at', 'desc')->first()->evento   ),1,1,'L',0);
                        
                            \Fpdf::SetXY($x+5,$y+3*$sy);
                            \Fpdf::Cell(20,$h,utf8_decode('Tipo:'),1,1,'L',0);
                    
                            \Fpdf::SetXY($x+25,$y+3*$sy);
                            \Fpdf::Cell(160,$h,utf8_decode(   \App\TipoProcesso::where('id','LIKE',$process['tipo_processo_id'])->first()->descricao   ),1,1,'L',0);
                        

                            $y+=((4*$sy) + 0.5);
                            
                }
            }

        \Fpdf::Output();//984315833 -- daiton
      
      
        exit;    

       
    }


}
