<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;


use File;
use Response;

use \App\DocsComunicacao;

class DocsComunicacaoController extends Controller
{
   
    public function store($data){

    
          // dd($data['arquivo']->getSize());

            if ($data['arquivo'] && $data['arquivo']->isValid()) {            
                if(($data['arquivo']->getSize()) <= 999999){
                 
                      $doc = new DocsComunicacao();
                      $doc->mensagem_id = $data['mensagem_id'];
                      $doc->nome        =  substr($data['arquivo']->getClientOriginalName(),0,80);
                      $doc->extencao    =  substr($data['arquivo']->extension(),0,3);
                      $doc->save();  
                      $data['arquivo']->storeAs('public/images/documentos/comunicacao/', $doc->id .'.'.  $doc->extencao);
               }
            }
        
        
    }

    public function show($id){        



        $path = (  base_path() . '/storage/app/public/images/documentos/comunicacao/'. $id . '.pdf');

        if (!File::exists($path)) {
            abort(404);
        }
    
        $file = File::get($path);
        $type = File::mimeType($path);
        
        $response = Response::make($file, 200);
        $response->header("Content-Type", $type);
    
        return $response;
    
    } 

   

}
