<?php

namespace App\Http\Controllers;

use App\DecisaoFinal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

use File;
use Response;

//use \App\Http\Requests\DecisaoRequest as Request;

class DecisaoFinalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         
    
    
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {


                $response  =  (DB::table('desicao')
                ->join('processes','desicao.processes_id','=','processes.id' )
                ->join('setors','setors.id','=','desicao.setor_id')
                ->join('users','users.id','=','desicao.user_id')
                ->join('soliciters','soliciters.id','=','processes.solicitante_id')
                ->select( 'desicao.id','processes.protocolo','soliciters.nome','setors.setor','users.name','desicao.decisao','desicao.justificativa','desicao.data')
                ->where('processes_id','like', $id))
                ->get();

                $docs =  (DB::table('docs_decisao')        
                ->select( 'id','processes_id','extencao')
                ->where('processes_id','like', $id))
                ->get();

           


                if(count($response) > 0 ){
                     return view('decisao.exibe')->with(compact('response','docs'));
                }

                return view('decisao.registra')->with(compact('id'));


                
                       
                    
    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(\App\Http\Requests\DecisaoRequest $request)
    {


//dd($request->all());

          $request['data']  = (new Carbon())->format('Y-m-d');
          $result =  DecisaoFinal::create($request->all());


          if(isset($request->all()['documentos'])){
              $this->setDocs($request,$result->id); 
          }

          //return redirect()->back();
          return redirect()->back()->with('success', 'Dados Cadastrados com sucesso !');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DecisaoFinal  $decisaoFinal
     * @return \Illuminate\Http\Response
     */
    public function show(DecisaoFinal $decisaoFinal)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DecisaoFinal  $decisaoFinal
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $decisao = DecisaoFinal::findOrFail($id);   
        
      
        return view('decisao.atualiza')->with(compact('decisao'));
    //    return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DecisaoFinal  $decisaoFinal
     * @return \Illuminate\Http\Response
     */
    public function update(\App\Http\Requests\DecisaoRequest $request, $id)
    {

//dd($request->all());

        $decisao = DecisaoFinal::find($id);
        $decisao->update($request->all());
        if(isset($request->all()['documentos'])){
            $this->setDocs($request,$decisao->id); 
        }
     //   return view('decisao.atualiza')->with(compact('decisao'));
   
        return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
   
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DecisaoFinal  $decisaoFinal
     * @return \Illuminate\Http\Response
     */

     public function destroy(DecisaoFinal $decisaoFinal)
    {
        //
    }
 
    public function setDocs($request,$id)
    {       

     //   dd($request->all());
        foreach ($request->all()['documentos'] as $key => $value) {
          if ($request->hasFile('documentos') && $request->file('documentos')[$key]->isValid()) {            
            if(($value->getSize()) <= 9999999 ){   
              if($value->extension() ==  'pdf'){
                
                    $doc = new \App\DocsDecisao();
                    $doc->processes_id = $id;
                    $doc->name    = $value->getClientOriginalName();
                    $doc->extencao     = $value->extension();
                    $doc->save();  
                    $value->storeAs('public/images/documentos/decisao/', $doc->id .'.'.  $doc->extencao  );

                }
              }
           }
        }
    }

  


    public function getDocs(Request $request){    
        
     //   dd($request->all());


        $path = (  base_path() . '/storage/app/public/images/documentos/decisao/'. $request->all()['id']   . '.' . $request->all()['extencao']);
        
        
        
        if (!File::exists($path)) {
            abort(404);
        }
        
        $file = File::get($path);
        $type = File::mimeType($path);
        

        $response = Response::make($file, 200);
        $response->header("Content-Type", $type);
           
        return $response;

    } 

    public function removeDocs(Request $request){   
        
        
       
        $extencao =   $request->all()['extencao'] ;
              
        $doc =   \App\DocsDecisao::find($request->all()['id']);
       
        //dd($doc);

        $path = (  base_path() . '/storage/app/public/images/documentos/decisao/'. $request->all()['id'] . '.'. $extencao );

       // dd($path);

        if (!File::exists($path)) {
            dd($doc->delete());
            abort(404);
        }

        File::delete($path);
          
        $doc->delete(); 
               
        return redirect()->back();
    } 



    public function print($id){

             
      
      
        $decisao =    DecisaoFinal::findOrFail($id);


     
        
        
      
        
        //dd($pagina);
     
     
        //str_split($parecer->parecer,2800); 
  
        
       // $pagina   =    str_split($parecer->parecer,2800); 
  
  
        
          \Fpdf::AddPage();
           
          \Fpdf::SetTitle('Prefeitura Municipal De Conceição do Coité',true);
       //  \Fpdf::SetTitle('Prefeitura Municipal De Santa Barbara',true);
        
         \Fpdf::SetMargins(0,0,0);      
         
          \Fpdf::Rect(15,15,185,32);
     
          \Fpdf::SetFillColor(200,200,200); 
    
          \Fpdf::Rect(15,47,185,5,'F');
    
          \Fpdf::Rect(145,15,55,32); 
          
          \Fpdf::Rect(15,65,185,5,'F');
    
          \Fpdf::Rect(15,47,35,18);
          \Fpdf::Rect(15,77,185,5,'F');
          \Fpdf::Rect(50,47,95,18);
          
  
          \Fpdf::Rect(15,170,185,5,'F');
  
          \Fpdf::Rect(145,47,55,18);
          
          \Fpdf::Rect(15,65,185,12); 
        
          \Fpdf::Rect(15,70,185,100); 
        
          \Fpdf::Rect(15,170,185,90);
       //   \Fpdf::Rect(15,264,185,5,'F');
        
         // \Fpdf::Rect(15,264,93,20);
         // \Fpdf::Rect(108,264,92,20);
    
          
          \Fpdf::SetFont('Arial', 'B', 13);
          \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,17,25,25);
          \Fpdf::SetXY(0,10);
          \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Conceição do Coité'),0,1,'C');
        //  \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal de Conceição do Coité'),0,1,'C');
          
        \Fpdf::SetFont('Arial', 'B', 15);
        
        \Fpdf::SetXY(145,25);
        \Fpdf::Cell(55,5,'PARECER',0,1,'C');
        \Fpdf::SetXY(145,30);
        \Fpdf::Cell(55,5, "ID/" . str_pad($decisao->id,8,'0',STR_PAD_LEFT),0,1,'C');
        
        \Fpdf::SetXY(155,32);
        
        \Fpdf::SetFont('Arial', 'B', 10);
        
        \Fpdf::SetXY(15,47.3);
        \Fpdf::Cell(35,5,utf8_decode('Nº Processo'),0,1,'L');
        
        \Fpdf::SetXY(50,47.3);
        \Fpdf::Cell(90,5,utf8_decode('Parecer dado por'),0,1,'L');
        
        
        \Fpdf::SetXY(145,47.3);
        \Fpdf::Cell(55,5,utf8_decode('Data do Parecer'),0,1,'L');
        
        \Fpdf::SetXY(15,65.2);
        \Fpdf::Cell(45,5,utf8_decode('Setor'),0,1,'L');
        
        \Fpdf::SetXY(15,77);
        \Fpdf::Cell(45,5,utf8_decode('Justificativa'),0,1,'L');
        
        
        \Fpdf::SetXY(15,170);
        \Fpdf::Cell(45,5,utf8_decode('Decisão'),0,1,'L');
        
       // \Fpdf::SetXY(15,264);
        //\Fpdf::Cell(93,5,utf8_decode('Assinatura do Solicitante'),0,1,'L');
        
        
        //\Fpdf::SetXY(108,264);
        //\Fpdf::Cell(92,5,utf8_decode('Data de Recebimento'),0,1,'L');
        
        \Fpdf::SetFont('Arial', 'B', 12);
        \Fpdf::SetXY(15,55.3);
        \Fpdf::Cell(35,6,utf8_decode( \App\Process::findOrFail($decisao->processes_id)->protocolo ),0,2,'C');
        
        \Fpdf::SetXY(50,55.3);
        \Fpdf::Cell(95,6,utf8_decode(\App\User::find($decisao->user_id)->name ),0,2,'C');
    

        \Fpdf::SetXY(135,55.3);
        \Fpdf::Cell(65,6,utf8_decode(  date("d/m/Y", strtotime($decisao->data))                   ),0,2,'C');
        
        // 
    
        \Fpdf::SetFont('Arial', 'B', 10);
        \Fpdf::SetXY(15,70);
        \Fpdf::Cell(185,6,utf8_decode( \App\Setor::FindOrFail($decisao->setor_id)->setor),0,2,'L');
   

         \Fpdf::SetFont('Arial', 'B', 8);
         \Fpdf::SetXY(15,176.0);

         \Fpdf::MultiCell(185,3,utf8_decode(   $decisao->decisao      ),0,'J');
        
   

      
       
  
       $pagina = [substr($decisao->justificativa,0,2500)];
        
       if (strlen($decisao->justificativa) > 2500){
         
         foreach ( (str_split((substr($decisao->justificativa,2500,strlen($decisao->justificativa))),2500)) as $key => $value) {
           
           $pagina[] = $value;
           
         }
       }

  
    foreach ($pagina as $key => $page) {
          
          \Fpdf::SetFont('Arial', 'B', 8);
          \Fpdf::SetXY(15,82);
  
             if($key > 0){
                \Fpdf::AddPage();
                \Fpdf::SetXY(15,15.8);
                \Fpdf::Rect(15,10,185,255);
                \Fpdf::SetXY(15,15);
          
              }
     //  dd($page);
  
     
     
     \Fpdf::MultiCell(185,3,utf8_decode(   $page      ),0,'J');
        
     
            if($key == (count($pagina)-1)){
                    \Fpdf::Rect(15,264,185,5,'F');
                    \Fpdf::Rect(15,264,93,20);
                    \Fpdf::Rect(108,264,92,20);
                    \Fpdf::SetXY(108,264);
                    \Fpdf::Cell(92,5,utf8_decode('Data de Recebimento'),0,1,'L');
                    
                    
                    \Fpdf::SetXY(15,264);
                    \Fpdf::Cell(93,5,utf8_decode('Assinatura do Responsavel'),0,1,'L'); 
                    \Fpdf::SetFont('Arial', 'B', 20);
                    \Fpdf::SetXY(109,270.8);
                    \Fpdf::Cell(91,5,utf8_decode('....../......./........'),0,1,'C');
             }
        
        
        
          }
  
  
           
         
  
       
        
        
          \Fpdf::Output();  
        
          exit;
    
        
    
  
  
  
  
  
  
  
  
  
  
  
      }
  




}
