<?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class NotificationEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    
    
   
    private $message; 


    public function __construct($message)
    {
        
        $this->message = $message;
    }
    
    public function broadcastWith(){
        return $this->message;
    }

    public function broadcastOn()
    {
        return new Channel('Notification');
    }


    public function broadcastAs()
    {
        return 'NotificationEvent';
    }
}
