@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

  @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Usuarios
          <small>cadastrados</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Usuarios</a></li>
          <li class="active">Listar</li>
        </ol>
      </section>
 


     
        <!-- Main content -->
       
     <!------------------------------------------------------------------------>
     <section class="content">
         <div class="row">      

        
            @foreach($users as $user) 
               @can('show',$user)
                     <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                        <gs-card-user usuario="{{ $user }}"  setor="{{ $user->Setors}}" atualiza = {{Auth::user()->getPermissoes[3]->status == 'ativo'}} />
                    </div>           
                @endcan
            @endforeach
           

        
           
          </div>      
                    
          <nav aria-label="..." class="text-center">
              {!! $users->render() !!}

          </nav>


       
        
      



        <div class="row">
            <div class="col-md-12">


                       
                  @if(Auth::user()->getPermissoes[2]->status == 'ativo')
                        <a href="{{route('usuario.create')}}" style="margin-left: 10px" class="btn btn-primary pull-right"><b>CADASTRAR</b></a>
                   @endif
                        <a href="{{route('index')}}" class="btn btn-primary  pull-right" ><b>CANCELAR</b></a>
            </div>                 
        </div>
    
      
      </section>
        
   
     <!--------------------------------------------------------------------------> 
   
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
