@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Setor
          <small>atualizar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> setores</a></li>
          <li class="active">atualizar</li>
        </ol>
      </section>
    <section class="content">
     

     <!------------------------------------------------------------------------>

     <div class="row">


        
        @include('partials.validation')   

        <div class="col-md-12">            




        <div class="col-md-4">


        

                           

                <!-- Profile Image -->
                   <div class="box box-info">
                  <div class="box-body box-profile">
                   
                    <img class="profile-user-img img-responsive img-circle" src="/images/setors/{{$setor->id}}.jpg" alt="{{$setor->setor}}">
                    <h3 class="profile-username text-center">{{$setor->setor}}</h3>
                    <p class="text-muted text-center">SETOR</p>
                    <ul class="list-group list-group-unbordered">
                
                    
                
                      @foreach($setor->Users as $key => $user) 
                          <li class="list-group-item">
                             
                            <b>{{$key+1}}º Usuario:</b> <a class="pull-right">{{$user->name}}</a>
                          </li>
                        @endforeach
                        
                     <li class="list-group-item">
                        <b>Email:</b> <a class="pull-right">{{$setor->email}}</a>
                      </li>
                      <li class="list-group-item">
                        <b>Telefone:</b> <a class="pull-right">{{$setor->telefone}}</a>
                      </li>
      
                      <li class="list-group-item">
                        <b>Obs:</b>{{$setor->obs}}</li>
                    </ul>
                   </div>
                  <!-- /.box-body -->
                </div>
                <!-- /.box -->


            </div>
            <div class="col-md-8">              
           


                    <!-- Horizontal Form -->
                    <div class="box box-info">
                      <div class="box-header with-border">
                        <h3 class="box-title">Altere os dados do setor</h3>
                      </div>
                      <!-- /.box-header -->
                      <!-- form start -->
                      <form class="form-horizontal" action="{{route('setor.update',$setor->id)}}" method="post" enctype="multipart/form-data">
                        <div class="box-body">
                          
                                {{ csrf_field() }}
                           

                          <input type="hidden" name="id" value="{{$setor->id}}">


                          <div class="form-group">
                             <label for="name" class="col-sm-2 control-label">Setor</label>          
                                <div class="col-sm-10">
                                 <input type="text" class="form-control" id="setor" name="setor"  value="{{old('name',$setor->setor)}}">
                              </div>
                          </div> 

                         
                        
                        
                    

                          
                          <div class="form-group">
                            <label for="setor" class="col-sm-2 control-label">Usuarios</label> 
                            <div class="col-sm-10">
                       
                       

                            <gs-set-user   users="{{\App\User::all()}}" users_setor="{{$setor->Users}}" />
                           </div>
                           </div> 
                      


                   
                        <div class="form-group">
                            <label for="telefone" class="col-sm-2 control-label">Telefone</label>          
                            <div class="col-sm-10">
                                <input type="tel" class="form-control" id="telefone" name="telefone"  value="{{old('telefone',$setor->telefone)}}">
                            </div>
                         </div> 
   

                        <div class="form-group">
                            <label for="email" class="col-sm-2 control-label">Email</label>          
                            <div class="col-sm-10">
                               <input type="text" class="form-control" id="email" name="email"  value="{{old('email',$setor->email)}}">
                            </div>
                        </div> 

                       
                         <div class="form-group">
                            <label for="foto" class="col-sm-2 control-label">Obs:</label>          
                             <div class="col-sm-10">
                                    <textarea  class="form-control" id="foto" name="obs"  value="{{$setor->obs}}">{{$setor->obs}}</textarea>
                             </div>
                        </div> 

                        <div class="form-group">
                                <label for="foto" class="col-sm-2 control-label"></label>          
                                 <div class="col-sm-10">
                                      <gs-image/>
                                 </div>
                            </div> 

                        
  


                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">

                        <a href="{{route('setor.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 
                           @if(Auth::user()->getPermissoes[8]->status == 'ativo')
                           <gs-button  title="Atualizar Setor"  mensagem="Deseja Atualizar Os Dados do Setor ?" label="ATUALIZAR"  status="1" ></gs-button>

                              
                           @endif
                        </div>
                        <!-- /.box-footer -->
                      </form>
                    </div>
                 



        
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    
    
    
    
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
